/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.visitor;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.visitor.AstAction;
import icyllis.flexmark.util.visitor.AstHandler;
import icyllis.flexmark.util.visitor.AstNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public abstract class AstActionHandler<C extends AstActionHandler<C, N, A, H>, N, A extends AstAction<N>, H extends AstHandler<N, A>> {
    @NotNull
    private final Map<Class<? extends N>, H> customHandlersMap = new HashMap<Class<? extends N>, H>();
    @NotNull
    private final AstNode<N> astAdapter;

    public AstActionHandler(@NotNull AstNode<N> astAdapter) {
        this.astAdapter = astAdapter;
    }

    @SafeVarargs
    @NotNull
    protected final C addActionHandlers(H[] ... handlers) {
        H[][] HArray = handlers;
        int n = HArray.length;
        for (int i = 0; i < n; ++i) {
            H[] moreHandlers;
            for (H handler : moreHandlers = HArray[i]) {
                this.customHandlersMap.put(((AstHandler)handler).getNodeType(), handler);
            }
        }
        return (C)this;
    }

    @NotNull
    protected C addActionHandler(@NotNull H handler) {
        this.customHandlersMap.put(((AstHandler)handler).getNodeType(), handler);
        return (C)this;
    }

    @Nullable
    private A getAction(@Nullable H handler) {
        return handler == null ? null : (A)((AstHandler)handler).getAdapter();
    }

    @Nullable
    public A getAction(@NotNull N node) {
        return this.getAction((N)((AstHandler)this.customHandlersMap.get(node.getClass())));
    }

    @Nullable
    public A getAction(@NotNull Class<?> nodeClass) {
        return this.getAction((N)((AstHandler)this.customHandlersMap.get(nodeClass)));
    }

    @Nullable
    protected H getHandler(@NotNull N node) {
        return (H)((AstHandler)this.customHandlersMap.get(node.getClass()));
    }

    @Nullable
    protected H getHandler(@NotNull Class<?> nodeClass) {
        return (H)((AstHandler)this.customHandlersMap.get(nodeClass));
    }

    @NotNull
    public Set<Class<? extends N>> getNodeClasses() {
        return this.customHandlersMap.keySet();
    }

    protected void processNode(@NotNull N node, boolean withChildren, @NotNull BiConsumer<N, A> processor) {
        A action = this.getAction(node);
        if (action != null) {
            processor.accept(node, action);
        } else if (withChildren) {
            this.processChildren(node, processor);
        }
    }

    protected final void processChildren(@NotNull N node, @NotNull BiConsumer<N, A> processor) {
        N child = this.astAdapter.getFirstChild(node);
        while (child != null) {
            N next = this.astAdapter.getNext(child);
            this.processNode(child, true, processor);
            child = next;
        }
    }

    protected final <R> R processNodeOnly(@NotNull N node, R defaultValue, @NotNull BiFunction<N, A, R> processor) {
        Object[] value = new Object[]{defaultValue};
        this.processNode(node, false, (n, h2) -> {
            value[0] = processor.apply(n, h2);
        });
        return (R)value[0];
    }
}

